VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmEmployee 
   Caption         =   "EMPLOYEES DATA ENTRY FORM"
   ClientHeight    =   7500
   ClientLeft      =   120
   ClientTop       =   465
   ClientWidth     =   12255
   OleObjectBlob   =   "frmEmployee.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmEmployee"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const EMP_SHEET = "EMPLOYEES"


Private Function AppPath() As String
    AppPath = ThisWorkbook.path & "\"
End Function

Private Sub CopyFileToFolder(ByVal sourcePath As String, ByVal destPath As String)
    On Error Resume Next
    FileSystem.FileCopy sourcePath, destPath
End Sub



Private Sub CalIcon_Click()
Call Calendar.SelectedDate(Me.txtHireDate)
End Sub

Private Sub ResetForm()
    txtEmpID.Value = GenerateNewEmpID
    txtFullName.Value = ""
    cboGender.Value = ""
    cboDepartment.Value = ""
    cboPosition.Value = ""
    txtHireDate.Value = Date
    cboStatus.Value = ""
    txtBasicSalary.Value = ""
    txtAllowances.Value = ""
    txtDeductions.Value = ""
    txtContact.Value = ""
    txtEmail.Value = ""
    txtAddress.Value = ""
    txtNotes.Value = ""
    
    Image1.Picture = Nothing
    Image2.Picture = Nothing
End Sub




Private Sub cmdReset_Click()
ResetForm
End Sub

Private Sub UserForm_Initialize()
    ResetForm
End Sub


Private Sub cmdSave_Click()

Dim ws As Worksheet
Dim r As Long

Set ws = Sheets(EMP_SHEET)

If txtFullName.Value = "" Then
    MsgBox "Full Name is required", vbExclamation
    Exit Sub
End If

r = NextEmptyRow(ws)

ws.Cells(r, 1).Value = txtEmpID.Value
ws.Cells(r, 2).Value = txtFullName.Value
ws.Cells(r, 3).Value = cboGender.Value
ws.Cells(r, 4).Value = cboDepartment.Value
ws.Cells(r, 5).Value = cboPosition.Value
ws.Cells(r, 6).Value = txtHireDate.Value
ws.Cells(r, 7).Value = cboStatus.Value
ws.Cells(r, 8).Value = txtBasicSalary.Value
ws.Cells(r, 9).Value = txtAllowances.Value
ws.Cells(r, 10).Value = txtDeductions.Value
ws.Cells(r, 11).Value = txtContact.Value
ws.Cells(r, 12).Value = txtEmail.Value
ws.Cells(r, 13).Value = txtAddress.Value
ws.Cells(r, 16).Value = txtNotes.Value

MsgBox "Employee Saved Successfully!", vbInformation
ResetForm

End Sub


Private Sub cmdUpdate_Click()

Dim ws As Worksheet
Dim r As Long

Set ws = Sheets(EMP_SHEET)

r = FindEmployeeRow(txtEmpID.Value)

If r = 0 Then
    MsgBox "Employee ID not found!", vbCritical
    Exit Sub
End If

ws.Cells(r, 2).Value = txtFullName.Value
ws.Cells(r, 3).Value = cboGender.Value
ws.Cells(r, 4).Value = cboDepartment.Value
ws.Cells(r, 5).Value = cboPosition.Value
ws.Cells(r, 6).Value = txtHireDate.Value
ws.Cells(r, 7).Value = cboStatus.Value
ws.Cells(r, 8).Value = txtBasicSalary.Value
ws.Cells(r, 9).Value = txtAllowances.Value
ws.Cells(r, 10).Value = txtDeductions.Value
ws.Cells(r, 11).Value = txtContact.Value
ws.Cells(r, 12).Value = txtEmail.Value
ws.Cells(r, 13).Value = txtAddress.Value
ws.Cells(r, 16).Value = txtNotes.Value

MsgBox "Employee Updated Successfully", vbInformation

End Sub


Private Sub cmdDelete_Click()

Dim ws As Worksheet
Dim r As Long

Set ws = Sheets(EMP_SHEET)

r = FindEmployeeRow(txtEmpID.Value)

If r = 0 Then
    MsgBox "Employee not found!", vbCritical
    Exit Sub
End If

If MsgBox("Are you sure to delete?", vbYesNo + vbQuestion) = vbNo Then Exit Sub

ws.Rows(r).Delete

MsgBox "Employee Deleted", vbInformation
ResetForm

End Sub


Private Sub cmdSearch_Click()

Dim ws As Worksheet
Dim r As Long

Set ws = Sheets(EMP_SHEET)

r = FindEmployeeRow(txtSearchBox.Value)

If r = 0 Then
    MsgBox "Employee not found!", vbExclamation
    Exit Sub
End If

txtEmpID.Value = ws.Cells(r, 1).Value
txtFullName.Value = ws.Cells(r, 2).Value
cboGender.Value = ws.Cells(r, 3).Value
cboDepartment.Value = ws.Cells(r, 4).Value
cboPosition.Value = ws.Cells(r, 5).Value
txtHireDate.Value = ws.Cells(r, 6).Value
cboStatus.Value = ws.Cells(r, 7).Value
txtBasicSalary.Value = ws.Cells(r, 8).Value
txtAllowances.Value = ws.Cells(r, 9).Value
txtDeductions.Value = ws.Cells(r, 10).Value
txtContact.Value = ws.Cells(r, 11).Value
txtEmail.Value = ws.Cells(r, 12).Value
txtAddress.Value = ws.Cells(r, 13).Value
txtNotes.Value = ws.Cells(r, 16).Value


Dim photoPath As String
Dim signPath As String

photoPath = ws.Cells(r, 14).Value
signPath = ws.Cells(r, 15).Value

If photoPath <> "" And Dir(photoPath) <> "" Then
    Image1.Picture = LoadPicture(photoPath)
Else
    Image1.Picture = Nothing
End If

If signPath <> "" And Dir(signPath) <> "" Then
    Image2.Picture = LoadPicture(signPath)
Else
    Image2.Picture = Nothing
End If


End Sub


Private Function PickFile() As String
    With Application.FileDialog(msoFileDialogFilePicker)
        .Title = "Select Image"
        .Filters.Clear
        .Filters.Add "Images", "*.jpg;*.png;*.jpeg"
        If .Show Then
            PickFile = .SelectedItems(1)
        End If
    End With
End Function



Private Sub cmdUploadPhoto_Click()

Dim sourcePath As String
Dim destPath As String
Dim empID As String
Dim r As Long

If txtEmpID.Value = "" Then
    MsgBox "Generate or load Employee ID first", vbExclamation
    Exit Sub
End If

empID = txtEmpID.Value

sourcePath = PickFile
If sourcePath = "" Then Exit Sub

'Build destination
destPath = AppPath & "Photos\" & empID & ".jpg"

'Copy file
FileCopy sourcePath, destPath

'Show on form
Image1.Picture = LoadPicture(destPath)

'Save path to sheet
r = FindEmployeeRow(empID)
If r <> 0 Then Sheets("EMPLOYEES").Cells(r, 14).Value = destPath

MsgBox "Photo Uploaded Successfully", vbInformation

End Sub




Private Sub cmdUploadSignature_Click()

Dim sourcePath As String
Dim destPath As String
Dim empID As String
Dim r As Long

If txtEmpID.Value = "" Then
    MsgBox "Generate or load Employee ID first", vbExclamation
    Exit Sub
End If

empID = txtEmpID.Value

sourcePath = PickFile
If sourcePath = "" Then Exit Sub

'Build destination
destPath = AppPath & "Signatures\" & empID & ".jpg"

'Copy file
FileCopy sourcePath, destPath

'Show on form
Image2.Picture = LoadPicture(destPath)

'Save path to sheet
r = FindEmployeeRow(empID)
If r <> 0 Then Sheets("EMPLOYEES").Cells(r, 15).Value = destPath

MsgBox "Signature Uploaded Successfully", vbInformation

End Sub






